package com.androidbook.simpleopengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

import javax.microedition.khronos.opengles.GL10;

public class CubeSmallGLUT extends SmallGLUT {

    private float mSize;
    
    private FloatBuffer mVertexBuffer;
    private FloatBuffer mNormalBuffer;
    private ByteBuffer mIndexBuffer;
    
    CubeSmallGLUT(float size) throws IllegalArgumentException {
    	if (size < 0.0f) {
    	    throw new IllegalArgumentException("Only use positive size values to CubeSmallGLUT");
    	}
    	
    	// Sześcian będzie skalowany do tego wymiaru.
    	mSize = size;
    	
    	if (mSize != 1.0f) {
    	    for (int vertex = 0; vertex < vertices.length; vertex++ ) {
    	        vertices[vertex] *= mSize;
    	    }
    	}
    	
    	mVertexBuffer = getFloatBufferFromFloatArray(vertices);
    	mNormalBuffer = getFloatBufferFromFloatArray(normals);
    	mIndexBuffer = getByteBufferFromByteArray(indices);
    }
    
    // Szaścian będzie wyśrodkowany wokół punktu początkowego, tak by obroty były sensowne.
    float vertices[] = {
	    // przód
	    -0.5f, 0.5f, 0.5f,   0.5f, 0.5f, 0.5f,   0.5f,-0.5f, 0.5f,  -0.5f,-0.5f, 0.5f,
	    
	    // tył
	     0.5f, 0.5f,-0.5f,  -0.5f, 0.5f,-0.5f,  -0.5f,-0.5f,-0.5f,   0.5f,-0.5f,-0.5f,
	    
	    // góra
	    -0.5f, 0.5f,-0.5f,   0.5f, 0.5f,-0.5f,   0.5f, 0.5f, 0.5f,  -0.5f, 0.5f, 0.5f,
	    
	    // dół
	    -0.5f,-0.5f, 0.5f,   0.5f,-0.5f, 0.5f,   0.5f,-0.5f,-0.5f,  -0.5f,-0.5f,-0.5f,
	    
	    // prawa
	     0.5f, 0.5f, 0.5f,   0.5f, 0.5f,-0.5f,   0.5f,-0.5f,-0.5f,   0.5f,-0.5f, 0.5f,
	     
	    // lewa
	    -0.5f, 0.5f,-0.5f, -0.5f, 0.5f, 0.5f,  -0.5f,-0.5f, 0.5f,  -0.5f,-0.5f,-0.5f,
    };
    
    byte indices[] = {
	    // przód
	    0,1,2, 2,3,0,
	    // tył
	    4,5,6, 6,7,4,
	    // góra
	    8,9,10, 10,11,8,
	    // dół
	    12,13,14,  14,15,12,
	    // prawa
	    16,17,18,  18,19,16,
	    // lewa
	    20,21,22,  22,23,20,
    };
    
    float normals[] = {
            // przód
            0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1,
            // tył
            0, 0, -1, 0, 0, -1, 0, 0, -1, 0, 0, -1,
            // góra
            0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0,
            // dół
            0, -1, 0, 0, -1, 0, 0, -1, 0, 0, -1, 0,
            // prawa
            1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0,
            // lewa
            -1, 0, 0, -1, 0, 0, -1, 0, 0, -1, 0, 0, };
    
    
    void draw(GL10 gl) {
    	// Potrzebne do prawidłowego usuwania niewidocznych wierzchołków.
    	gl.glFrontFace(GL10.GL_CW);
    	       
    	// Upewniamy się, że stan jest prawidłowy.
        gl.glEnableClientState(GL10.GL_NORMAL_ARRAY);

        // Ustawienie wierzchołków.
        gl.glVertexPointer(3, GL10.GL_FLOAT, 0, mVertexBuffer);

        // Ustawienie normalnych dla prawidłowego oświetlenia.
        gl.glNormalPointer(GL10.GL_FLOAT, 0, mNormalBuffer);

        // Narysowanie elementów.
        gl.glDrawElements(GL10.GL_TRIANGLES, indices.length,
                GL10.GL_UNSIGNED_BYTE, mIndexBuffer);
	
    	// GLUT wyłącza stan klienta -- my nie. Dlaczego to robi? .. 
    	// TODO: rozważyć zastosowanie metod preDraw, draw, postDraw ...
    }
    
    void drawAgain(GL10 gl) {
        // Używana do ponownego rysywania gdy wierzchołek i normalna nie uległy zmianie - inaczej nie będzie działać.
    
        // Narysowanie elementów - zakładając, że wszystkie powyższe przygotowania zostały wykonane.
    	gl.glDrawElements(GL10.GL_TRIANGLES, indices.length, GL10.GL_UNSIGNED_BYTE, mIndexBuffer);
    }
    
    
    static void drawSimpleCube (GL10 gl, boolean drawAsWireframe) {
        float vertices[] = {
                -1,1,1, 1,1,1, 1,-1,1, -1,-1,1,
                1,1,-1, -1,1,-1, -1,-1,-1, 1,-1,-1
        };
        byte indices[] = {
                0,1,2, 2,3,0,  1,4,7, 7,2,1,  0,3,6, 6,5,0,
                3,2,7, 7,6,3,  0,1,4, 4,5,0,  5,6,7, 7,4,5
        };
        FloatBuffer vertexBuffer = getFloatBufferFromFloatArray(vertices);
        ByteBuffer indexBuffer = getByteBufferFromByteArray(indices);
        gl.glVertexPointer(3, GL10.GL_FLOAT, 0, vertexBuffer);
        if (drawAsWireframe) {
            gl.glDrawElements(GL10.GL_LINE_LOOP, indices.length, GL10.GL_UNSIGNED_BYTE, indexBuffer);
        } else {
            gl.glDrawElements(GL10.GL_TRIANGLES, indices.length, GL10.GL_UNSIGNED_BYTE, indexBuffer);
        }
        
    }
    
}
